// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unseady state and converctive mass transfer
//Example 7_1_2 Page:431
//Title: Unsteady state diffusion in a semi infinite slab
//================================================
model Ex7_1_2

//================
//Parameter section
parameter Real co(unit = "kmol/m^3") = 1E-02 "Initial concentration of solute A";
parameter Real c1(unit = "kmol/m^3") = 0.1 "Concentration of solute at front face";
parameter Real K(unit = "-") = 2 "Distribution coefficient at equilibrium";
parameter Real x1(unit = "m") = 0.01 "Length 1";
parameter Real x2(unit = "m") = 0 "Length 2";
parameter Real kc(unit = "m/s") = 2E-07 "Convective mass transfer coefficient";
parameter Real t(unit = "h") = 3E+04 "Time required for diffusion";
parameter Real Da(unit = "m^2/s") = 4E-09 "Diffusivity of the solution";

//================
//Variable section
Real A(unit = "-") "Unsteady term";
Real B(unit = "-") "Unsteady term";
Real B1(unit = "-") "Unsteady term";
Real c_1(unit = "kmol/m^3") "Concentration at solid surface";
Real c_2(unit = "kmol/m^3") "Concentration at x=0 ";
Real C_L(unit = "kmol/m^3") "Concentration at the interface";

//================
//Equation section
equation
A = (K*kc/Da)*sqrt(Da*t) ; // Unsteady term
B = x1/(2*sqrt(Da*t)) ; // Unsteady term
 // From the chart 1-Y is 0.26, from figure 5.3-3
0.26 = (c_1-co)/((c1/K)-co) ; // Concentration at x = 0.01
B1 = x2/(2*sqrt(Da*t)) ; // Unsteady term
 // From the chart 1-Y is 0.62, from figure 5.3-3
0.62 = (c_2-co)/((c1/K)-co) ; // Concentration at x = 0.01
C_L = K*c_2 ; // Interface concentration
end Ex7_1_2;
//==========================================================
