// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_3_2 Page:443
//Title: Mass transfer from flat plate
//================================================
model Ex7_3_2

//===============
//Parameter section
parameter Real v(unit = "m/s") = 0.061 "Velocity of the fluid";
parameter Real L(unit = "m") = 0.244 "Length of the tube";
parameter Real Da(unit = "m^2/s") = 1.245E-09 "Diffusivity of the component A";
parameter Real mu(unit = "Pa.s") = 8.71E-04 "Viscosity of the fluid";
parameter Real rho(unit = "kg/m^3") = 996 "Density of the fluid";
parameter Real cao(unit = "kmol/m^3") = 0.02948 "Initial concentration of the plate";
parameter Real cai(unit = "kmol/m^3") = 0 "Final concentration";
parameter Real xBM(unit = "-") = 1 "Logrithmic mean concentration";

//==============
//Variable section
Real NSc(unit = "-") "Schmit number";
Real NRe(unit = "-") "Reynolds number";
Real jD(unit = "-") "jD factor";
Real kc(unit = "m/s") "Mass transfer coefficient";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//================
//Equation section
equation
NSc = mu/(rho*Da) ; // Schmit number of the fluid
NRe = L*v*rho/mu ; // Reynolds number of the fluid
jD = 0.99*(NRe)^(-0.5) ; // jD factor
jD = (kc/v)*NSc^(2/3) ; // Mass transfer coefficient
Na = (kc/xBM)*(cao-cai) ; // Mass flux
end Ex7_3_2;
//===============================================================
