// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_3_3 Page:446
//Title: Mass transfer from a sphere
//================================================
model Ex7_3_3

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real v(unit = "m/s") = 0.305 "Velocity of the fluid";
parameter Real D(unit = "mm") = 25.4 "Diameter of the tube";
parameter Real Da(unit = "m^2/s") = 6.92E-06 "Diffusivity of the component A";
parameter Real mu(unit = "Pa.s") = 1.93E-05 "Viscosity of the fluid";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 318 "Temperature at which diffusion takes place";
parameter Real rho(unit = "kg/m^3") = 1.113 "Density of the fluid";
parameter Real pa1(unit = "Pa") = 74 "Vapor pressure of the gas at 1";
parameter Real pa2(unit = "Pa") = 0 "Vapor pressure of the gas at 2";

//==============
//Variable section
Real Nsc(unit = "-") "Schmit number";
Real Nre(unit = "-") "Reynolds number";
Real Nsh(unit = "-") "Shrewood number";
Real kc(unit = "m/s") "Mass transfer coefficient of liquid phase";
Real kG(unit = "kmol/m^2.s.Pa") "Mass transfer coefficient of gas phase";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";
Real A(unit = "m^2") "Area of sphere";
Real W(unit = "kmol/s") "Amount evaporated";

//===============
//Equation section
equation
Nsc = mu/(rho*Da) ; // Schmit number of the fluid
Nre = D*v*rho/(1000*mu) ; // Reynolds number of the fluid
Nsh = 2 + 0.552*Nre^0.53*Nsc^(1/3) ; // Shrewood number of the fluid
Nsh = kc*D/(1000*Da) ; // Mass transfer coefficient in gas phase
kG = kc/(R*T) ; // Mass transfer coefficient in liq phase
Na = kG*(pa1-pa2) ; //Mass transfer flux
A = pi*(D/1000)^2 ; // Area of the sphere
W = Na*A ; // Amount of solute vaporized
end Ex7_3_3;
//======================================================
