// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_3_4 Page:449
//Title: Mass transfer of liquid in packed bed
//================================================
model Ex7_3_4

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real Q(unit = "m^3/s") = 5.514E-07 "Volumetric flow rate of the fluid";
parameter Real d(unit = "mm") = 6.375 "Diameter of the sphere";
parameter Real D(unit = "m") = 0.0667 "Diameter of the tower";
parameter Real Da_25(unit = "m^2/s") = 1.21E-09 "Diffusivity of the component at 25 C";
parameter Real mu_25(unit = "Pa.s") = 0.894E-03 "Viscosity of the fluid at 25 C";
parameter Real mu_26(unit = "Pa.s") = 0.8718E-03 "Viscosity of the fluid at 26.1 C";
parameter Real T(unit = "K") = 299.1 "Temperature at which diffusion takes place";
parameter Real To(unit = "K") = 298 "Reference temperature";
parameter Real a(unit = "m^2") = 0.01198 "Surface area of the sphere";
parameter Real rho(unit = "kg/m^3") = 996.7 "Density of the fluid";
parameter Real cai(unit = "kmol/m^3") = 2.948E-02 "Final concentration of the plate";
parameter Real ca1(unit = "kmol/m^3") = 0 "Initial concentration";
parameter Real epslon(unit = "-") = 0.436 "Void fraction of bed";

//==============
//Variable section
Real NSc(unit = "-") "Schmit number";
Real NRe(unit = "-") "Reynolds number";
Real Da_26(unit = "m^2/s") "Diffusivity of the fluid at 26.1 C";
Real jD(unit = "-") "jD factor";
Real kc(unit = "m/s") "Mass transfer coefficient of liquid";
Real A(unit = "m^2") "Cross sectional area of tower";
Real v(unit = "kmol/s") "Velocity of the fluid";
Real ca2(unit = "kmol/m^3") "Outlet concentration of benzoic acid";

//===============
//Equation section
equation
Da_26 = Da_25*(T/To)*(mu_25/mu_26) ; // Diffusivity at 26.1 C
NSc = mu_26/(rho*Da_26) ; // Schmit number of the fluid
NRe = (d/1000)*v*rho/mu_26 ; // Reynolds number of the fluid
A = (pi/4)*D^2 ; // Cross sectional area of tower
v = Q/A ; // Equation of continuity to find fluid velocity
jD = (1.09/epslon)*NRe^(-2/3) ; // jD factor
jD = (kc/v)*(NSc)^(2/3) ; // Mass transfer coefficient
 // Since the given value and the value of kc obtained are same. It is used for calculating ca2
(1/(ca2-ca1))*(((cai-ca1)-(cai-ca2))/(log((cai-ca1)/(cai-ca2)))) = Q/(a*4.665E-06);  // Exit concentration of benzoic acid
end Ex7_3_4;
//==================================================
