// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.10-2 Page 562
//Title: Heat balance on a dryer
//================================================
model Ex9_10_2

//================
//Parameter section
parameter Real Ls(unit = "kg/h") = 453.6 "Mass flow rate of solid";
parameter Real Cps(unit = "kJ/kg.K") = 1.465 "Specific heat capacity of solid";
parameter Real Cpa(unit = "kJ/kg.K") = 4.187 "Specific heat capacity of moisture";
parameter Real X1(unit = "kg/kg") = 0.04 "Humidity of incoming solid";
parameter Real X2(unit = "kg/kg") = 0.002 "Humidity of exit solid";
parameter Real H2(unit = "kg.water/kg.air") = 0.01 "Humidity of the exit air";
parameter Real Ts1(unit = "C") = 26.7 "Temperature of incoming solid";
parameter Real Ts2(unit = "C") = 62.8 "Temperature of Exit solid";
parameter Real TG1(unit = "C") = 37.8 "Temperature of Exit air";
parameter Real TG2(unit = "C") = 93.3 "Temperature of incoming air";
parameter Real To(unit = "C") = 0 "Reference temperature";
parameter Real lamda(unit = "kJ/kg.K") = 2501 "Latent heat of vaporisaition at reference temperature";

//================
//Variable section
Real G(unit = "kg/h") "Mass flow rate of outflowing air";
Real HG2(unit = "kJ/kg") "Enthalpy of entering air";
Real HG1(unit = "kJ/kg") "Enthalpy of exit air";
Real HS1(unit = "kJ/kg") "Enthalpy of incomming solid";
Real HS2(unit = "kJ/kg") "Enthalpy of exit solid";
Real H1(unit = "kg.water/kg.dryair") "Humidity of Incoming solid";

//================
//Equation section
equation
G*H2 + Ls*X1 = G*H1 + Ls*X2 ; // Materail balance for dryer
HG2 = (1.005 + 1.88*H2)*(TG2 - To) + H2*lamda ; // Enthalpy of entering air
HG1 = (1.005 + 1.88*H1)*(TG1 - To) + H1*lamda ; // Enthalpy of exit air
HS1 = Cps*(Ts1 - To) + X1*Cpa*(Ts1 - To) ; // Enthalpy of entering solid
HS2 = Cps*(Ts2 - To) + X2*Cpa*(Ts2 - To) ; // Enthalpy of leaving solid
G*HG2 + Ls*HS1 = G*HG1 + Ls*HS2 ; // Energy balance for the dryer
end Ex9_10_2;
//====================================================
