// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.12-1 Page 573
//Title: Sterlization of cane food
//================================================
model Ex9_12_1

//================
//Parameter section
parameter Real t1(unit = "min") = 20 "Difference in time for first time period";
parameter Real t2(unit = "min") = 20 "Difference in time for second time period";
parameter Real t3(unit = "min") = 33 "Difference in time for third time period";
parameter Real T1(unit = "F") = 160 "Average temperature for first time period";
parameter Real T2(unit = "F") = 210 "Average temperature for second time period"; 
parameter Real T3(unit = "F") = 230 "Average temperature for third time period"; 
parameter Real T1_SI(unit = "C") = 71.1 "Average temperature for first time period";
parameter Real T2_SI(unit = "C") = 98.9 "Average temperature for second time period"; 
parameter Real T3_SI(unit = "C") = 110 "Average temperature for third time period";
parameter Real z(unit = "F") = 18 "Minimum requirement for sterlization";
parameter Real z_SI(unit = "C") = 10 "Minimum requirement for sterlization";

//================
//Variable section
Real Fo_E(unit = "min") "Total time required for sterlization";
Real Fo_SI(unit = "min") "Total time required for sterlization";

//================
//Equation section
equation
Fo_E = t1*10^((T1-250)/z) + t2*10^((T2-250)/z) + t3*10^((T3-250)/z) ; // Time rquired for sterlization
Fo_SI = t1*10^((T1_SI-121.1)/z_SI) + t2*10^((T2_SI-121.1)/z_SI) + t3*10^((T3_SI-121.1)/z_SI) ; // Time rquired for sterlization
end Ex9_12_1;
//===============================================
