// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.6-2 Page 541
//Title: Drying time from rate of drying curve
//================================================
model Ex9_6_2

//================
//Parameter section
parameter Real x1(unit = "kg.H2O/kg.dryair") = 0.38 "Initial moisture content";
parameter Real x2(unit = "kg.H2O/kg.dryair") = 0.25 "Final moisture content";
parameter Real Ls_A(unit = "kg/m^2") = 21.5 "Mass of material dried per unit area";
parameter Real Rc(unit = "kg/h.m^2") = 1.51 "Rate of drying of material";

//================
//Variable section
Real t(unit = "h") "Time required for drying of the material";

//================
//Equation section
equation
t = (Ls_A/Rc)*(x1-x2) ; // Time required for drying
end Ex9_6_2;
//================================================
