// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.6-3 Page 543
//Title: Prediction of rate constant of drying
//================================================
model Ex9_6_3

//================
//Parameter section
parameter Real H(unit = "kg/kg") = 0.01 "Humidity of air";
parameter Real T(unit = "C") = 65.6 "Inlet temperature of air";
parameter Real Tw(unit = "C") = 28.9 "Wet bulb temperature";
parameter Real rho(unit = "kg/m^3") = 1.037 "Density of air mixture";
parameter Real v(unit = "m/s") = 6.1 "Velocity of air flow";
parameter Real lamda(unit = "kJ/kg") = 2433 "Latent heat of vaporisation";
parameter Real A(unit = "m") = 0.457 "Surface available for evaporation";

//================
//Variable section
Real vH(unit = "m^3/kg") "Humid volume of the air";
Real G(unit = "kg/h.m^2") "Mass velocity of the air";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real Rc(unit = "kg/h.m^2") "Rate of drying";
Real E(unit = "kg/h") "Rate of evaporation";

//================
//Equation section
equation
vH = (2.83E-03 + 4.56E-03*H)*(T+273.15) ;
 // 273.15 is added to convert C to K
G = v*rho*3600 ; /// Mass velocity of air
 // 3600 is multiplied to convert h to s
h = 0.0204*G^(8/10) ; // Heat transfer coefficient
Rc = (h/(lamda*1000))*(T-Tw)*3600 ;
 // 3600 is multiplied to convert h to s
E = Rc*A^2 ; // Evaporation of moisture
end Ex9_6_3;
//===============================================
