// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.4-1 Page 8
//Title: Gas-law constant
//==============================================================
package Ex1_4_1
model Ex1_4_1_A

//=====================
// Parameter section
parameter Real n(unit = "lb mol")=1 "One lb mol";
parameter Real P(unit = "psig")= 14.7 "Pressure at STP";
parameter Real T(unit = "C")=32 "Temperature at STP";
parameter Real V(unit = "ft3")=359 "Volume per lb mol";

//=====================
// Variable section 
Real R(unit = "ft.psig/lb mol.R") "Universal gas constant";

//==========================
//Equation section
equation
P*V=n*R*(T+460); // Ideal gas law
     // 460 is added to convert C to R
end Ex1_4_1_A;
//==============================================================

//==============================================================
model Ex1_4_1_B

//=======================
//Parameter section
parameter Real P(unit = "Pa")=101325 "Pressure at STP";
parameter Real V(unit = "m3")=22.414 "Volume at STP";
parameter Real T(unit = "K")=273.15 "Temperature at STP";
parameter Real n(unit = "mol")=1  "One mole of gas";

//======================
//Variable section
Real R(unit = "m3.Pa/Kmol K") "Universal gas constant";

//======================
//Equation section
equation
P*V = n*R*T; // Ideal Gas equation
end Ex1_4_1_B;
end Ex1_4_1;
//==============================================================
