// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.5-1 Page 10
// Title: Concentration of orange juice 
//==========================================================
model Ex1_5_1

//===================
//Parameter section
parameter Real F(unit = "kg/hr")=1000 "Flowrate of Feed";
parameter Real xf(unit = "-")=0.0708 "Concentration in Mass% of feed stream";
parameter Real xc(unit = "-")=0.58 "Concentration in Mass% of thick juice stream";
parameter Real xw(unit = "-")=0 "Concentration in Mass% of water stream";

//===================
//Variable section
Real W(unit = "kg/hr") "Flowrate of water";
Real C(unit = "kg/hr") "Flowrate of concentrated juice";

//===================
//Equation section
equation
F = C + W; // Overall mass balance
F * xf = C*xc + W*xw; // Component balance
end Ex1_5_1;
//==========================================================
