// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn., Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.5-2 Page 11
// Title: Crystallization of KNO3, Recycle without chemical reaction
// ====================================================
model Ex1_5_2

//==================
//Parameter section
parameter Real F(unit = "kg/hr")=1000 "Feed flowrate";
parameter Real xf(unit = "-")=0.2 "Composition with respect to KNO3";
parameter Real xw(unit = "-")=0   "Composition with respect to KNO3";
parameter Real xs(unit = "-")=0.5 "Composition with respect to KNO3";
parameter Real xp(unit = "-")=0.96 "Composition with respect to KNO3"; 
   //It is given as 4% of water in crystal stream in the textbook, so it is taken as 96% of solute          composition 
parameter Real xr(unit = "-")=0.375 "Composition with respect to KNO3";

//==================
//Variable section
Real W(unit = "kg/hr") "Flowrate of water stream";
Real P(unit = "kg/hr") "Flowrate of crystal stream";
Real R(unit = "kg/hr") "Flowrate of recycle stream";
Real S(unit = "kg/hr") "Flowrate of stream flowing into crystallizer";

//===================
//Equation section
equation
F = W + P; // Overall Mass balance of system
F*xf = W*xw + P*xp; // Solute balance for overall system
S = R + P; // Solute balance around crystallizer
S*xs = R*xr + P*xp; // Solute component balance around crystallizer
end Ex1_5_2;
//======================================================
