// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.6-2 Page 16
// Title: Heating of Milk
//===============================================
model Ex1_6_2

//=================
//Parameter section
parameter Real M(unit = "kg/hr")=4536 "Mass flowrate of milk";
parameter Real cp(unit= "kJ/kg.K")=3.85 "Specific heat capacity of milk";
parameter Real T1(unit = "C")=4.4 "Inlet temp of milk";
parameter Real T2(unit = "C")=54.4 "Exit temp of milk";

//=================
//Variable section
Real Q(unit = "kW")"Heat required";

//=================
//Equation section
equation
Q = (M/3600)*cp*(T2-T1); // Heat required
  // The above equation is divided by 3600 to convert hr to second
  //Note : // specific heat values are taken from table 1.6-1, page : 15
end Ex1_6_2;
//==================================================
