// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.7-1 Page 19
// Title: Heating of fermentation medium
//====================================================
model Ex1_7_1

//=================
//Parameter section
parameter Real M1(unit = "kg/hr")=2000 "Mass flowrate of liquid";
parameter Real cp1(unit = "kJ/kg.K")=4.06 "Specific heat capacity of liquid";
parameter Real cp2(unit = "kJ/kg.K")=4.21 "Specific heat capacity of water";
parameter Real T1(unit = "C")=30 "Inlet temp of stream 1";
parameter Real T2(unit = "C")=70  "Exit temp of stream 1";
parameter Real t1(unit = "C")=95 "Inlet temp of stream 2";
parameter Real t2(unit = "C")=85 "Exit temp of stream 2";
parameter Real tr(unit = "C")=25 "Reference temperature";

//================
//Variable section
Real W(unit = "kg/hr") "Mass flowrate of water";
Real Hwater_in(unit = "kJ/hr") "Enthalpy of water at inlet";
Real Hliq_in(unit = "kJ/hr") "Enthalpy of liquid at inlet";
Real Hwater_out(unit = "kJ/hr") "Enthalpy of water at outlet";
Real Hliq_out(unit = "kJ/hr") "Enthalpy of liquid at outlet";
Real deltaH(unit = "kJ/hr")"Change in heat";

//=================
//Equation section
equation  
Hliq_in = M1*cp1*(T1 - tr); // Enthalpy of liquid at inlet
Hwater_in = W*cp2*(t1 - tr); // Enthalpy of water at inlet
Hliq_out = M1*cp1*(T2 - tr); // Enthalpy of liquid at exit
Hwater_out = W*cp2*(t2 - tr); // Enthalpy of water at exit
Hliq_in + Hwater_in = Hliq_out + Hwater_out ; // Energy balance equation
deltaH = Hliq_out - Hliq_in; // Change in enthalpy
    // 25 C is taken as reference temperature
end Ex1_7_1;
//=====================================================
