//C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-1: Introduction to Engineering principles and units 
//Example 1.7-2 Page 21 
// Title: Heat and Material balance in combustion
//===================================================
model Ex1_7_2

//=================
//Parameter section
parameter Real mCO(unit = "kmol")=1 "Moles of CO in";
parameter Real O2(unit = "kmol")=0.21 "Moles of O2 in Air";
parameter Real N2(unit = "kmol")=0.79 "Moles of N2 in Air";
parameter Real exO2(unit = "-")=0.9 "Excess O2 %";
parameter Real Tr(unit = "K")=298 "Reference temperature";
parameter Real TCO(unit = "K")=473 "Temperature of CO";
parameter Real Tair(unit = "K")=373 "Temperature of CO2";
parameter Real Tout(unit = "K")=1273 "Exit temperature";
parameter Real deltaH(unit = "kJ/hr")=282990 "Standard state enthalpy";

//================
//Variable section
Real nCO2(unit = "kmol")"Moles of CO2 at exit";
Real nO2(unit = "kmol")"Moles of O2 at exit";
Real nN2(unit = "kmol")"Moles of N2 at exit";
Real mN2(unit = "kmol")"Moles of N2 given in";
Real O2reqd(unit = "kmol") "O2 Theoretical Required for complete reaction";
Real O2act(unit = "kmol") "O2 Actually supplied for reaction";
Real air(unit = "kmol") "Moles of air at exit";
Real HCO(unit = "kJ/hr") "Enthalpy of CO";
Real HCO2(unit = "kJ/hr") "Enthalpy of CO2";
Real HO2(unit = "kJ/hr") "Enthalpy of O2";
Real Hair(unit = "kJ/hr") "Enthalpy of air";
Real HN2(unit = "kJ/hr") "Enthalpy of N2";
Real q(unit = "kJ/hr") "Heat supplied to system";
Real q_w(unit = "W") "Heat supplied to system";

// Reaction: CO + (1/2)O2 ----> CO2
//==================
//Equation section
equation
O2reqd = 1/2 * mCO "O2 Required";
O2act = O2reqd * (1+exO2) "O2 Actully supplied";
nN2 = O2act * (N2/O2)"N2 added";
nN2 = mN2 "Since N2 is the tie component";
nO2 = O2act - O2reqd "O2 at exit";
nCO2 = (1/1)*mCO  "CO2 at exit";
air = nN2 + O2act "Total moles of air";
Hair = air*29.29*(Tair - Tr) "Enthalpy of air";
HCO = mCO*29.38*(TCO - Tr)"Enthalpy of CO";
HCO2 = nCO2*49.91*(Tout - Tr) "Enthalpy of CO2";
HO2 = nO2*33.25*(Tout - Tr) "Enthalpy of O2";
HN2 = nN2*31.43*(Tout - Tr) "Enthalpy of N2";
// NOTE: All cp values are taken from table 1.6-1, page : 15
//===================
// Energy balance
HCO + Hair + q + deltaH = HCO2 + HO2 + HN2 "Heat added to the system";
q_w = q*(10^3/3600) "Converting to Watts";
 // q is multiplied by 1000 to convert kJ to J and divided by 3600 to convert h to s
end Ex1_7_2;
//=======================================================
