// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_2_1 Page:487
//Title: Dissolved O2 concentration in water
//================================================
model Ex10_2_1

//================
//Variable section
Real xa(unit = "-") "Mole fraction oxygen dissolved in water";

//================
//Parameter section
parameter Real pa(unit = "atm") = 0.21 "Partial pressure of oxygen in air";
parameter Real H(unit = "atm/mol.frac") = 4.38E+04 "Henry s law constant";

//================
//Equation section
equation
pa = H*xa ; // Henry's law
end Ex10_2_1;
//==================================================
