// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_3_1 Page:589
//Title: Equilibrium stage contact for CO2-Air-Water
//================================================
model Ex10_3_1

//================
//Parameter section
parameter Real Lo(unit = "kmol/hr") = 300 "Liquid incoming flow rate";
parameter Real Vo(unit = "kmol/hr") = 100 "Vapor incoming flow rate";
parameter Real H(unit = "atm/mol.frac") = 0.142E+04 "Henry s law constant";
parameter Real ya2(unit = "-") = 0.2 "Mole fraction of inlet gas stream";
parameter Real xa2(unit = "-") = 0 "Mole fraction of inlet liquid stream";

//================
//Variable section
Real xa1(unit = "-") "Mole fraction of solute in liquid";
Real ya1(unit = "-") "Mole fraction of solute in vapor";
Real L1(unit = "kmol/h") "Molar flow rate of liquid leaving";
Real V1(unit = "kmol/hr") "Molar flow rate of vapor leaving";
Real V(unit = "kmol/hr") "Molar flow rate of inert";

//=================
//Equation section
equation
V=Vo*(1-ya2) ; // Flow rate of inert
ya1 = H*xa1 ; // Henry's law constant
Lo*(xa2/(1-xa2))+V*(ya2/(1-ya2)) = Lo*(xa1/(1-xa1))+V*(ya1/(1-ya1)) ; // Mass balance equation
L1 = Lo/(1-xa1) ; // Flow rate of liquid in leaving stream
V1 = V/(1-ya1) ; // Flow rate of vapor in leaving stream
end Ex10_3_1;
//==============================================
