// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-10 Stage and continuous gas-liquid separation processes
//Example 10_6_3 Page:625
//Title: Use of transfer units for packed tower
//================================================
model Ex10_6_3

//================
//Parameter section
parameter Real ky1(unit = "kmol/s.m^3.molfrac") = 3.78E-02  "Mass transfer coefficient";
parameter Real ky2(unit = "kmol/s.m^3.molfrac") = 2.183E-02  "Mass transfer coefficient";
parameter Real V(unit = "kmol/s") = 3.852E-03 "Vapor flow rate";
parameter Real S(unit = "m^2") = 0.186 "Surface area of packing";
parameter Real y1(unit = "-") = 0.026 "Mole fraction of vapor phase";
parameter Real yim1(unit = "-") = 0.979 "Equilibrium concentration";
parameter Real y2(unit = "-") = 0.005 "Mole fraction of vapor phase";
parameter Real yim2(unit = "-") = 0.997 "Equilibrium concentration";
parameter Real yyim1(unit = "-") = 0.00602 "Interface equilibrium concentration";
parameter Real yyim2(unit = "-") = 0.01025 "Interface equilibrium concentration";

//===============
//Variable section
Real Hg1(unit = "m") "Height of transfer units";
Real Hg2(unit = "m") "Height of transfer units";
Real Ng1(unit = "-") "Number of transfer units";
Real Ng2(unit = "-") "Number of transfer units";
Real E1(unit = "-") "Equilibrium concentration at 1";
Real E2(unit = "-") "Equilibrium concentration at 2";
Real Eavg(unit = "-") "Average equilibrium concentration";
Real z1(unit = "m") "Height of packing";
Real z2(unit = "m") "Height of packing with different value of mass transfer coefficient";

//================
//Equation section
equation
Hg1 = V/(ky1*S) ; // Height of transfer units
E1 = yim1/(1-y1) ; // Equilibrium concenrtation 1
E2 = yim2/(1-y2) ; // Equilibrium concentration 2
Eavg = (E1+E2)/2 ; // Avg. equilibrium concentration
Ng1 = Eavg*(y1-y2)/yyim1 ; // Number of transfer units
z1 = Ng1*Hg1 ; // Height of packing
Hg2 = V/(ky2*S) ; // Height of transfer units
Ng2 = (y1-y2)/yyim2 ; // Number of transfer units
z2 = Hg2*Ng2 ; // Height of packing
end Ex10_6_3;
//========================================================
