// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_4_2 Page:660
//Title: Minimum reflux ratio and total reflux ratio in rectification  
//================================================
model Ex11_4_2

//================
//Parameter section
parameter Real xd(unit = "-") = 0.95 "Mole fraction of distillte";
parameter Real x(unit = "-") = 0.49 "Mole fraction of liq. at intercet of equilibrium line";
parameter Real y(unit = "-") = 0.702 "Mole fraction of vapor at intercet of equilibrium line";

//================
//Variable section
Real Rm(unit = "-") "Minimum reflux ratio";

//=================
//Equation section
equation
(Rm/(Rm+1)) = (xd - y)/(xd - x) ; // Minimum reflux ratio
end Ex11_4_2;
//====================================================
