// C.J. Geankopolis, Transport processs and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-11 Vapor liquid separation processes
//Example 11_7_3 Page:687
//Title: Minimum reflux ratio and number of operating stages at operating reflux ratio 
//================================================
model Ex11_7_3

//================
//Parameter section
parameter Real xf[4] = {0.4,0.25,0.2,0.15} "Mole fraction of liquid components in feed";
parameter Real xd[4] = {0.62,0.349,0.031,0} "Distillated compositions";
parameter Real xw[4] = {0,0.07,0.507,0.423} "Bottoms mole fraction";
parameter Real k1[4] = {3.12,1.38,0.60,0.28} "Distribution coefficients at 99.5 C";
parameter Real q(unit = "-") = 1 "Thermal condition of feed";
parameter Real teta_as[4](unit = "-") = {1.21,1.20,1.2096,1.201} "Assumed teta";
parameter Real Nm(unit = "-") = 5.4 "Minimum number of stages required";
parameter Real D(unit = "kmol/h") = 64.48 "Distillate flow rate";
parameter Real W(unit = "kmol/h") = 35.516 "Bottoms flow rate";

//================
//Variable section
Real sum[4] "Sum to find whether the assumed teta is correct";
Real Rm(unit = "-") "Minimum reflux ratio";
Real alpha[4] "Relative volataility";
Real R(unit = "-") "Actual reflux ratio";
Real A(unit = "-") "Ratio of actual reflux ratio";
Real B(unit = "-") "Ratio of Minimum reflux ratio";
Real N(unit = "-") "Actual number of stages";
Real Nr(unit = "-") "Number of stages in rectification section";
Real Ns(unit = "-") "Number of stages in stripping section";

//================
//Equation section
equation
for i in 1:4 loop
alpha[i] = k1[i]/k1[3] ; // Relative volataility
sum[i] = ((alpha[i]*xf[i])/(alpha[i] - teta_as[i])); // Sum to validate the assumption of teta
end for;
Rm + 1 = ((alpha[1]*xd[1])/(alpha[1] - teta_as[2])) + ((alpha[2]*xd[2])/(alpha[2] - teta_as[2])) + ((alpha[3]*xd[3])/(alpha[3] - teta_as[2])) + ((alpha[4]*xd[4])/(alpha[4] - teta_as[2])); // Minimum reflux ratio
R = 1.5*Rm ; // Actual reflux ratio
A = R/(R+1) ; 
B = Rm/(Rm + 1) ;
// From graph Nm/N = 0.49, from figure 11.7-3
0.49 = Nm/N ; // Actual number of stages
log(Nr/Ns) = 0.206*log((xf[3]/xf[2])*(W/D)*(xw[2]/xd[3])^2) ; // Location of the feed tray
Nr + Ns = N ; // Rectification section trays
end Ex11_7_3;
//=====================================================
