// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_7_1 Page:718
//Title: Material balance for counter current stage process
//================================================
model Ex12_7_1

//=============
//Parameter section
parameter Real xco(unit = "-") = 0 "Initial composition of C in Raffinate";
parameter Real xao(unit = "-") = 0.3 "Initial composition of A in Raffinate";
parameter Real ycn(unit = "-") = 1 "Composition of C in Extract";
parameter Real yan(unit = "-") = 0 "Composition of A in Extract";
parameter Real Lo(unit = "kg/hr") = 200 "Flow rate of aquous solution";
parameter Real Vo(unit = "kg/hr") = 600 "Flow rate of solvent";
 // From the above flow rates and bi-nodal curve is plotted and the compositions are found from the     figure 12.7.3
parameter Real xcn(unit = "-") = 0.017 "Composition of raffinate obtained from graph";
parameter Real yc1(unit = "-") = 0.9 "Composition of extract obtained from graph";
parameter Real M(unit = "kg/hr") = 800 "Mixture flow rate";

//=============
//Variable section
Real xcm(unit = "-") "Composition of C in mixture";
Real xam(unit = "-") "Composition of A in mixture";
Real LN(unit = "kg/hr") "Flow rate of aquous after 1st stage";
Real V1(unit = "kg/hr") "Flow rate of solvent afetr 1st stage";

//=============
//Equation section
equation
xcm = (Lo*xco + Vo*ycn)/(Lo + Vo) ; // Composition of C in mixture
xam = (Lo*xao + Vo*yan)/(Lo + Vo) ; // Composition of A in mixture
LN + V1 = M ;
LN*xcn + V1*yc1 = M*xcm ;
end Ex12_7_1;
//==================================================
