// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-12 Liquid-Liquid and fluid-solid separation processes
//Example 12_9_1 Page:726
//Title: Single stage leaching of laked soya beans
//================================================
model Ex12_9_1

//==============
//Parameter section
parameter Real L(unit = "kg/hr") = 100 "Flow rate of solvent";
parameter Real V2(unit  = "kg/hr") = 100 "Flaked soya bean oil";
parameter Real ya(unit = "-") = 0.2 "Concentration of soyabean in solution";
parameter Real xc(unit = "-") = 0.8 "Concentration of insoluble solvent";
parameter Real xa2(unit = "-") = 0 "Concentration of soya bean in entering solvent";
parameter Real xc2(unit = "-") = 1 "Concentration of soya bean at exit of solvent";
parameter Real yao(unit = "-") = 1 "Concentration of soyabean";
// On drawing these composition in graph, 12.9-2a
parameter Real N1_1(unit = "kg-solid/kg-solution") = 1.5 "Solid present after stage 1";

//==============
//Variable section
Real Lo(unit = "kh/hr") "Amount of solute in the solution";
Real B(unit = "kg/hr") "Amount of insoluble solid";
Real xam(unit = "-") "Concentration of mixture";
Real No(unit = "kg-soild/kg solution") "Solid present per kg of solution initially";
Real Nm(unit = "kg-soild/kg solution") "Solid present per kg of solution finally";
Real M(unit = "kg/hr") "Mass of the mixture";
Real L1(unit = "kg/hr")"Flow rate of solvent after stage 1";
Real V1(unit = "kg/hr") "Flow rate of solution after stage 1";

//==============
//Equation section
equation
B = L*(1-ya) ; //Amount of insoluble solid
Lo = L*(1-xc) ; // Amount of solute in the solution
Lo + V2 = M; // Mass of mixture solution
Lo*yao + V2*xa2 = M*xam ; //Concentration of mixture
No = B/Lo ; //Solid present per kg of solution initially
No*Lo = Nm*M; // Solid present per kg of solution finally
N1_1*L1 = Nm*M; // Flow rate of solvent after stage 1
L1 + V1 = M; // Flow rate of solution after stage 1
end Ex12_9_1;
//==============================================================
