// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.10-1 Page 788
//Title: Prediction of performance in Reverse-Osmosis unit
//================================================
model Ex13_10_1

//=============
//Parameter section
parameter Real c1(unit = "Kg.Nacl/m^3") = 2.5 "Concentration of Nacl initially";
parameter Real cw2(unit = "Kg.solvent/m^3") = 997 "Concentration of water";
  // Since cw2 is very dilute and its density is not available it is taken from table 13.9.1 as density of water
parameter Real Aw(unit = "m^2") = 4.81E-04 "Area of memberane";
parameter Real As(unit = "m^2") = 4.42E-07 "Area of memberane";
parameter Real Delp(unit = "atm") = 27.20 "Pressure drop in RO unit";
parameter Real Delpi(unit = "atm") = 1.89 "Difference in osmotic pressure obtained from linear interpolation from appendix";

//=============
//Variable section
Real Nw(unit = "kg.solvent/s.m^2") "Flux of water";
Real Ns(unit = "kg.solute/s.m^2") "Flux of solute";
Real B(unit = "atm^-1") "Constant composed of various parameters related to memberane design";
Real R(unit = "-") "Solute rejection";
Real c2(unit = "kg.solute/m^3") "Concentration of solute at the exit";

//==============
//Equation section
equation
Nw = Aw*(Delp - Delpi) ; // Flux of water
B = Aw/(As*cw2) ;// Constant composed of various parameters related to memberane design
R = (B*(Delp - Delpi))/(1+ B*(Delp - Delpi)) ; //Solute rejection
R = (c1 - c2)/c1 ; // Initial concentration of the solute
Ns = As*(c1 - c2) ; // Flux of the solute
end Ex13_10_1;
//===============================================
