// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.2-2 Page 758
//Title: Dialysis to remove urea from blood
//================================================
model Ex13_2_2

//===============
//Parameter section
parameter Real t(unit = "mm") = 0.025 "Thickness of the memberane";
parameter Real A(unit = "m^2") = 2 "Area of the permeation";
parameter Real kc1(unit = "m/s") = 1.25E-05 "Mass transfer coefficient at blood side";
parameter Real kc2(unit = "m/s") = 3.33E-05 "Mass transfer coefficient at urea side";
parameter Real Pm(unit = "m/s") = 8.73E-06 "Permeablity of the memberane";
parameter Real Conc(unit = "g/ml") = 0.02/100 "Concentration at plane 1";
parameter Real C2(unit = "g/m^3") = 0 "Concentration at plane 2";

//===============
//Variable section
Real C1(unit = "g/m^3") "Imitial concentration";
Real Na(unit = "g/m^2.S") "Flux of the urea";
Real rate(unit = "g/hr") "Rate at which urea is colleced";

//================
//Equation section
equation
C1 = Conc*10^6 ; // Initial concentration
    // 10^6 is multiplied to convert ml to m^3
Na = (C1 - C2)/((1/kc1)+(1/Pm)+(1/kc2)) ; // Flux of urea
rate = Na*A*3600 ; // Rate of removal of urea
    // 3600 is multiplied to convert s to hr
end Ex13_2_2;
//=======================================
