// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.4-2 Page 768
//Title: Design of memberane unit for air seperation
//================================================
model Ex13_4_2

//==============
//Parameter section
parameter Real qf(unit = "cm^3") = 10^6 "Feed flow rate";
parameter Real xf(unit = "-") = 0.209 "Feed composition";
parameter Real t(unit = "cm") = 2.54E-03 "Thickness of the memberane";
parameter Real Ph(unit = "cmHg") = 190 "Pressure in feed side";
parameter Real Pl(unit = "cmHg") = 19 "Pressure on the permeate side";
parameter Real Pa(unit = "cm^3.cm/s.cm^2.cmHg") = 500E-10 "Permeablity on the A";
parameter Real alpha(unit = "-") = 10 "Ratio of permeablities";
parameter Real teta(unit = "-") = 0.2 "permeste cut fraction";

//==============
//Variable section
Real a(unit = "-") "Quadratic equation constant";
Real b(unit = "-") "Quadratic equation constant";
Real c(unit = "-") "Quadratic equation constant";
Real y(unit = "-") "Permeate composition";
Real Am(unit = "cm^2") "Area required";
Real xo(unit = "-") "Desired composition in reject";

//==============
//Equation section
equation
a = teta + (Pl/Ph) - (Pl/Ph)*teta - alpha*teta - alpha*(Pl/Ph) + alpha*(Pl/Ph)*teta ; // Quadratic eqn constant 
b = 1 - teta - xf - (Pl/Ph) - (Pl/Ph)*teta + alpha*teta + alpha*(Pl/Ph) - alpha*(Pl/Ph)*teta + alpha*xf ; // Quadratic eqn constant 
c = -alpha*xf ; // Quadratic eqn constant 
y = (-b + sqrt(b^2 - 4*a*c))/(2*a) ; // Permeate composition
xo = (xf-teta*y)/(1-teta) ; // Mass balance equation
Am = (teta*qf*y)/((Pa/t)*(Ph*xo - Pl*y)) ; // Areq required
end Ex13_4_2;
// ==========================================
