// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.9-2 Page 786
//Title: Experimental determination of memberane permeablity
//================================================
model Ex13_9_2

//===============
//Parameter section
parameter Real c1(unit = "Kg.Nacl/m^3") = 10 "Concentration of Nacl initially";
parameter Real c2(unit = "Kg.Nacl/m^3") = 0.39 "Concentration of Nacl finally";
parameter Real q(unit = "m^3/s") = 1.92E-08 "Flow rate of solution";
parameter Real cw2(unit = "Kg.solvent/m^3") = 997 "Concentration of water";
 // Since cw2 is very dilute and its density is not available it is taken from table 13.9.1 as density of water
parameter Real A(unit = "m^2") = 2E-03 "Area of memberane";
parameter Real Delp(unit = "atm") = 54.42 "Pressure drop in the memberane";
parameter Real Delpi(unit = "atm") = 7.48 "Difference in osmotic pressure obtained from linear interpolation from table 13.9.1";

//===============
//Variable section
Real Nw(unit = "kg.solvent/s.m^2") "Flux of water";
Real Ns(unit = "kg.solute/s.m^2") "Flux of solute";
Real X(unit = "kg.solvent/s.m^2.atm") "Pm/Lm is reperesented as X";
Real Y(unit = "m/s") "Ds.Ks/Lm is represented by Y";
Real B(unit = "atm^-1") "Constant composed of various parameters related to memberane design";
Real R(unit = "-") "Solute rejection";

//===============
//Equation section
equation
Nw = q*cw2*(1/A) ; // Flux of water
Ns = Nw*c2/cw2 ; // Flux of solvent
Nw = X*(Delp - Delpi) ; // Pm/Lm is reperesented as X
Ns = Y*(c1 - c2) ; // Ds.Ks/Lm is represented by Y
B = X/(Y*cw2) ; // Constant composed of various parameters related to memberane design
R = (B*(Delp - Delpi))/(1+ B*(Delp - Delpi)) ; //Solute rejection
end Ex13_9_2;
//===================================================
