// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.2-3 Page 813
//Title: Rate of washing and total filter cycle time 
//================================================
model Ex14_2_3

//==============
//Parameter section
parameter Real Kp(unit = "s/m^6") = 37.93 "Slope obtained by plotting the given data";
parameter Real B(unit = "s/m^3") = 16.1 "Intercept from the given data";
parameter Real vf(unit = "m^3") = 3.37 "Volume of filtrate to be recovered";
parameter Real t_ini(unit = "s") = 269.7 "Time required in previous example";
parameter Real t_clean(unit = "min") = 20 "Time taken for cleaning of filter";

//==============
//Variable section
Real wash_rate(unit = "m^3/s") "Rate of washing of filter cake";
Real t(unit = "s") "Time required for washing";
Real t_cycle(unit = "min") "Total cycle time";

//==============
//Equation section
equation
wash_rate = 1/(4*(Kp*vf + B)) ; // Rate of washing
t = 0.1*vf/wash_rate ; // Time required for washing
  // Since 10% of fluid is used for washing
t_cycle = t_clean + t_ini/60 + t/60 ; // Total cycle time
 // t is divided by 60 to convert min to s
end Ex14_2_3;
//==================================================
