// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-1 Page 85
//Title: Metering of small liquid flows
//================================================
model Ex2_10_1

//===============
// Libraries 
extends Modelica.Constants;

//=============
//Parameter section
parameter Real D(unit = "m") = 2.22E-03 "Diameter of capillary";
parameter Real L(unit = "m") = 0.317 "Length of the capillary";
parameter Real h(unit = "m") = 0.0655 "Manometer height";
parameter Real rho_1(unit = "kg/m^3") = 875 "Density of fluid";
parameter Real mu(unit = "Pa.s") = 1.13E-03 "Viscosity of fluid";
parameter Real rho_2(unit = "kg/m^3") = 996 "Density of measuring fluid";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//=============
//Variable section
Real Delp(unit = "N/m^2") "Pressure drop";
Real V(unit = "m/s") "Velocity of fluid";
Real Q(unit = "m^3/s") "Volumetric flow rate";
Real NRe(unit = "-") "Reynolds number";

//=============
//Equation section
equation
Delp = h*g*rho_2 ; //Pressure drop
Delp = (32*mu*V*L)/(D^2) ; // Velocity of fluid
Q = V*(pi/4)*D^2 ; // Volumetric flow rate 
NRe = (D * rho_1 * V )/ mu ; // Reynolds number
end Ex2_10_1;
//==================================================
