// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-5 Page 91
//Title: Flow of gas inline and pressure drop
//================================================
model Ex2_10_5

//=============
//Parameter section
parameter Real D(unit = "m") = 0.01 "Diameter of tube";
parameter Real G(unit = "kg/m^2.s") = 9 "Mass rate of fluid";
parameter Real L(unit = "m") = 200 "Length of tube";
parameter Real P1(unit = "Pa") = 2.0265E+05 "Pressure at inlet";
parameter Real mu(unit = "Pa.s") = 1.77E-05 "Viscosity of the fluid";
parameter Real R(unit = "J/kmol.K") = 8314.3 "Ideal gas constant";
parameter Real T(unit = "K") = 298.15 "Temperature of the fluid";
parameter Real f(unit = "-") = 0.009 "Friction factor";
parameter Real MW(unit = "kg/kmol") = 28.08 "Molecular weight of flowing fluid";

//=============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real P2(unit = "Pa") "Exit pressure";

//=============
//Equation
equation
NRe = (D*G)/(mu) ; // Reynolds number 
P1^2 - P2^2 = (4*f*L*G^2*R*T)/(D*MW) ;
end Ex2_10_5;
//===============================================
