// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-6 Page 94
//Title: Friction loss and Mechanical energy balance
//================================================
model Ex2_10_6

//============
//Parameter section
parameter Real mu(unit = "lbm/ft.s") = 2.33E-04 "Viscosity of fluid";
parameter Real rho(unit = "lbm/ft^3") = 60.52 "Density of fluid";
parameter Real Q(unit = "ft^3/s") = 0.223 "Volumetric flow rate fluid";
parameter Real D3(unit = "ft") = 0.3353 "Area of tank";
parameter Real D4(unit = "ft") = 0.1722 "Area of section 3";
parameter Real A1(unit = "ft^2") = 0 "Area of tank";
parameter Real A3(unit = "ft^2") = 0.0884 "Area of section 3";
parameter Real A4(unit = "ft^2") = 0.02330 "Area of section 4";
parameter Real gc(unit = "") = 32.174 "Gravitational correction";
parameter Real f2(unit = "lbm.ft/lbf.s2") = 0.0048 "friction factor in section 2";
parameter Real L2(unit = "ft") = 20 "Length upto the section 2";
parameter Real L5(unit = "ft") = 185 "Length upto the section 2";
parameter Real K3(unit = "-") = 0.75 "Loss coefficient in 4-elbow";
parameter Real K6(unit = "-") = 0.75 "Loss coefficient in 2-elbow";

//============
//Variable section
Real K1(unit = "-") "Contraction Loss coefficient in 4-inch pipe";
Real K4(unit = "-") "Contraction Loss coefficient in 4-2-inch pipe";
Real V3(unit = "ft/s") "Velocity at section 3";
Real V4(unit = "ft/s") "Velocity at section 4";
Real NRe1(unit = "-") "Reynold number in 4-inch pipe";
Real NRe2(unit = "-") "Reynold number in 4-2-inch pipe";
Real h1(unit = "ft.lbf/lbm") "head loss in in tank exit"; 
Real h2(unit = "ft.lbf/lbm") "head loss in 4-inch pipe"; 
Real h3(unit = "ft.lbf/lbm") "head loss in 4-inch elbow"; 
Real h4(unit = "ft.lbf/lbm") "head loss in 4-2-inch pipe"; 
Real h5(unit = "ft.lbf/lbm") "head loss in 2-inch pipe"; 
Real h6(unit = "ft.lbf/lbm") "head loss in 2-elbow pipe"; 
Real F(unit = "ft.lbf/lbm") "Total head loss";
Real H(unit = "ft") "Heigtht above which fluid has to be discharged";

//============
//Equation section
equation
V3 = Q/A3 ; //Velocity in section 3
V4 = Q/A4 ;  // Velocity in section 4
K1 = 0.55*(1); //Contraction Loss coefficient in 4-inch pipe
h1 = K1*(V3^2/(2*gc));// head loss in in tank exit
NRe1 =(D3*rho*V3)/mu ; //Reynolds number
h2 = 4*f2*(V3^2/(2*gc))*(L2/D3) ; //head loss in 4-inch pipe
 // The friction factor for the corresponding reynolds number is obtained from figure 2.1.3 page : 88
h3 = K3*(V3^2/(2*gc)) ; //head loss in 4-inch elbow
K4 = 0.55*(1-(A4/A3)) ; // Loss coefficient in 4-2 inch pipe
h4 = K4*(V4^2/(2*gc)) ; //head loss in 4-2 inch pipe
NRe2 = (D4*rho*V4)/mu ; // Reynolds number
h5 = 4*f2*(V4^2/(2*gc))*(L5/D4) ;//"head loss in 2-inch pipe 
 // The friction factor for the corresponding reynolds number is obtained from figure 2.1.3 page : 88
h6 = 2*K6*(V4^2/(2*gc)) ; //head loss in 2-elbow pipe
F = h1+h2+h3+h4+h5+h6 ; // Total head loss
H*(gc/gc) = V4^2/(2*gc) + F ; // Heigtht above which fluid has to be discharged
end Ex2_10_6;
//=============================================
