// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.11-1 Page 102
//Title: Compressible flow of natural gas
//================================================
model Ex2_11_1

//===============
// Libraries 
extends Modelica.Constants;

//=============
//Parameter section
parameter Real D(unit = "m") = 1.016 "Diameter of tube";
parameter Real F(unit = "kgmol/s") = 2.077 "Molar flow rate of fluid";
parameter Real L(unit = "m") = 1.609E+05 "Length of tube";
parameter Real P2(unit = "Pa") = 170.3E+03 "Pressure at inlet";
parameter Real mu(unit = "Pa.s") = 1.04E-05 "Viscosity of the fluid";
parameter Real R(unit = "J/kmol.K") = 8314.3 "Ideal gas constant";
parameter Real T(unit = "K") = 288.15 "Temperature of the fluid";
parameter Real f(unit = "-") = 0.0027 "Friction factor";
parameter Real MW(unit = "kg/kmol") = 16 "Molecular weight of flowing fluid";

//=============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real P1(start = 620.5E+03) "Exit pressure";
Real G(unit = "kg/m^2.s") "Mass velocity";
Real A(unit = "m^2") "Area of cross section";

//=============
//Equation
equation
A = (pi/4)*D^2 ; //Area of pipe
G = F*MW/A ; // Mass velocity
NRe = (D*G)/(mu) ; // Reynolds number 
P1^2 - P2^2 = (4*f*L*G^2*R*T)/(D*MW) + ((2*G^2*R*T)/MW )*log(P1/P2) ; // Pressure at inlet
 // The friction factor for the corresponding reynolds number is obtained from figure 2.1.3 page : 88
end Ex2_11_1;
//===============================================
