// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International
//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances
//Example 2.2-1 Page 32
//Title: Units and Dimensions of Force
//==========================================
package Ex2_2_1

//================
model Ex2_2_1_a
//===================
//Parameter Section
parameter Real m(unit = "lb") = 3 "Mass of the Object";
parameter Real g(unit = "ft/s^2") = 32.174 "Gravitational Constant";
parameter Real gc(unit = "lbm.ft/lbf.s^2") = 32.174 "Gravitational correction";

//===================
//Variable Section
Real F(unit = "lbf") "Force Exerted by the given mass";

//===================
//Equation Section
equation
F = m * g / gc; // Newtons Second Law";
end Ex2_2_1_a;
//====================

model Ex2_2_1_b

//===================
//Parameter Section
parameter Real m(unit = "lb") = 3 "Mass of the Object";
parameter Real g(unit = "cm/s^2") = 980.665 "Gravitational Constant";

//===================
//Variable Section
Real F(unit = "dyne") "Force Exerted";

//===================
//Equation Section
equation
F = m * g * 453.59 "Newtons Second Law";
// m is multiplied with "453.59" to convert "lb" to "gram"
end Ex2_2_1_b;
//=============================
 
model Ex2_2_1_c

//===================
//Parameter Section
parameter Real m(unit = "lb")=3 "Mass of the Object";
parameter Real g(unit = "m/s^2") = 9.8066 "Gravitational Constant";

//===================
//Variable Section
Real F(unit = "N") "Force Exerted";

//===================
//Equation Section
equation
F = m*g*(1/2.2046) "Newtons Second Law";
      // m is multiplied by "(1/2.2046)" to convert ft to m
end Ex2_2_1_c;
//===================================
end Ex2_2_1;
