// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.2-2 Page 34
//Title: Pressure in Storage Tank
//================================================
model Ex2_2_2

//================
//Parameter Section
parameter Real P0_eng(unit = "Psia") = 14.696 "Atmospheric Pressure";
parameter Real P0_SI(unit = "Pa") = 101325 "Atmospheric Pressure";
parameter Real sg_oil(unit = "-") = 0.917 "Specific Gravity of oil";
parameter Real rho_water_eng(unit = "lbm/ft^3") = 62.43 "Density of water";
parameter Real rho_water_SI(unit = "kg/m^3") = 1000 "Density of water";
parameter Real sg_water(unit = "-") = 1 "Specific Gravity of Water";
parameter Real h1(unit = "ft") = 10 "Height of oil layer";
parameter Real h2(unit = "ft") = 2 "Height of water layer";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//================
//Variable Section
Real P1_eng(unit = "Psia") "Pressure due to oil layer";
Real P2_eng(unit = "Psia") "Pressure due to oil and water layer";
Real P1_SI(unit = "Pa") "Pressure due to oil layer";
Real P2_SI(unit = "Pa") "Pressure due to oil and water layer";
Real Pgauge(unit = "Psig") "Gauge pressure";

//=================
//Equation Section
equation
P1_eng = h1*sg_oil*rho_water_eng*(1/144) + P0_eng ; // Pressure of oil layer
 //(1/144) is gravity correction term
P2_eng = P1_eng + h2*sg_water*rho_water_eng*(1/144) ; //Total Pressure 
 //(1/144) is gravity correction term
P1_SI = h1*0.3048*sg_oil*rho_water_SI*g + P0_SI ; // Pressure of oil layer
 // 0.3048 is multiplied with h1 to convert ft to m
P2_SI = P1_SI + h2*0.3048*sg_water*rho_water_SI*g ; //Total Pressure
 // 0.3048 is multiplied with h1 to convert ft to m
Pgauge = P2_eng - P0_eng;
end Ex2_2_2;
//==================================================
