// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.6-1 Page 51
//Title: Flow of crude oil and overall mass balance
//================================================
model Ex2_6_1

//==============
//Parameter section
parameter Real Q(unit  = "m^3/s")=1.388E-03 "Volumetric flow rate of fluid";
parameter Real A1(unit = "m^2") = (0.02330*0.0929) "Area of pipe of section 1"; 
parameter Real A3(unit = "m^2") = (0.01414*0.0929) "Area of pipe of section 3";
parameter Real rho(unit = "kg/m^3") = 892 "Density of fluid";

//==============
//Variable section
Real m1(unit = "kg/s") "Mass flow rate of fluid in section 1";
Real m3(unit = "kg/s") "Mass flow rate of fluid in section 3";
Real v1(unit = "m/s") "Average velocity of fluid in section 1";
Real v3(unit = "m/s") "Average velocity of fluid in section 3";
Real G(unit = "kg/m^2.s") "Mass velocity of fluid";

//==============
//Equation section
equation
m1 = Q*rho ; // Mass flow rate in section 1
m3 = m1/2 ; // Mass flow rate in section 3
v1 = m1/(rho*A1) ; // Velocity of fluid in section 1
v3 = m3/(rho*A3) ; // Velocity of fluid in section 3
G = m1/A1 ; //Mass velocity in section 1
end Ex2_6_1;
//======================================================
