// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.7-2 Page 62
//Title: Energy balance on flow systems with pump
//================================================
model Ex2_7_2

//===============
//Parameter section
parameter Real rho(unit = "kg/m^3") = 968.5 "Density of the system";
parameter Real vol(unit = "m^3/min") = .567 "Volumetric flow rate of stream";
parameter Real P_E(unit = "kW") = 7.45 "Energy added by the pump";
parameter Real HE_E(unit = "kW") = 1408 "Energy added by Heat exchanger";
parameter Real z1(unit = "m") = 0 "Height of section 1";
parameter Real z2(unit = "m") = 20 "Height of section 2";
parameter Real g(unit = "m/s^2") = 9.80665 "Acceleration due to gravity";
parameter Real H1(unit = "kJ/kg") = 355.90*10^3 "Enthalpy at temperature at 18.33 C";  

// The enthalpy values are taken from appendix A.2

//==============
//Variable section
Real Ws(unit = "J/kg") "shaft work done";
Real Q(unit = "J/kg") "Heat added per kg of fluid";
Real H2(unit = "J/kg") "Enthalpy at section 2";
Real m1(unit = "kg/s") "Mass flow rate in section 1";

//===============
//Equation section
equation
m1 = vol*rho/60 ; //Mass flow rate in section 1
   // m1 is divided by 60 to convert min to sec
Ws = -(P_E*1000)/(m1) ; // Shaft work
Q = -(HE_E*1000)/(m1) ; // Heat added per kg of working fluid
Q - Ws = (z2 - z1)*g  + (H2-H1) ; 
   // 1000 is multiplied to convert kJ to J
// The value of temperature corresponding to H2 from steam tables is 48.4 C
end Ex2_7_2;
//====================================================
