// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1.-2 Page 117
//Title: Force on cylinder in a tunnel
//================================================
model Ex3_1_2

//============
//Parameter section
parameter Real dp(unit = "m") = 0.09 "Diameter of particle";
parameter Real L(unit = "m") = 1 "Length of the cylinder";
parameter Real v(unit = "m/s") = 1 "Veloctity of flow";
parameter Real cd(unit = "-") = 1.4 "Drag coefficient";
parameter Real rho(unit = "kg/m^3") = 997.2 "Density of air";
parameter Real mu(unit = "kg/m.s") = 0.9142E-03 "Viscosity of the fluid";

//===============
// Variable section
Real NRe(unit = "-") "Reynolds number";
Real Fd(unit = "N") "Drag force";

//============
// Equation section
equation
NRe = (dp*rho*v)/mu ; // Reynolds number of the fluid
Fd = cd*(v^2/2)*rho*L*dp ; // Drag coefficient of the fluid
end Ex3_1_2;
//====================================================
