// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1.-4 Page 121
//Title: Pressure drop and flow of gases in packed bed
//================================================
model Ex3_1_4

//===============
// Libraries 
extends Modelica.Constants;

//==============
//Parameter section
parameter Real dp(unit = "mm") = 12.7 "Diameter of the particle";
parameter Real L(unit = "m") = 2.44 "Length of the bed";
parameter Real epslon(unit = "-") = 0.38 "Voidage of bed";
parameter Real dia(unit = "m:") = 0.61 "Diameter of the bed";
parameter Real M(unit = "kg/s") = 0.358 "Mass flow rate of the gas";
parameter Real mu(unit = "kg/m.s") = 1.9E-05 "Viscosity of the fluid";
parameter Real p1(unit = "Pa") = 1.1*101325 "Pressure of air at entrance";
parameter Real deltaP(unit = "Pa") = 0.05E+05 "Assumed pressure drop";
parameter Real MW(unit = "kg/kmol/K") = 28.97 "Average molecular weight of the air"; 
parameter Real T(unit = "K") = 311 "Temperature of flwing air";
parameter Real R(unit = "J/kmol.K") = 8314.34 "Universal gas constant";

//=============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real rhoavg(unit = "kg/m^3") "Density of the gas";
Real pavg(unit = "Pa") "Average pressure";
Real p2(unit = "Pa") "Exit pressure";
Real deltaP_act(unit = "Pa") "Actual pressure drop";
Real A(unit = "m^2") "Area of cross section of bed"; 

//==============
//Equation section
equation
A = (pi/4)*dia^2 ; // Area of bed
NRe = ((dp/1000)*(M/A))/((1-epslon)*mu) ; // Reynolds number of the bed
p2 = p1 - deltaP ; // Pressure at the exit
pavg = (p1 + p2)/2 ;
rhoavg = (MW/(R*T))*pavg ; // Average density of the fluid
(deltaP_act*rhoavg/((M/A)^2))*(dp/(L*1000))*(epslon^3/(1-epslon)) = 150/NRe  + 1.75 ; // Pressure at the section 2
       // dp is divided by 1000 to convert mm to m
end Ex3_1_4;
//===========================================
