// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.3-2 Page 137
//Title: Break power of centrifugal pump
//================================================
model Ex3_3_2

//==============
//Parameter section
parameter Real Q(unit ="m^3/min") = 28.32 "Volumetric flow rate of the fluid";
parameter Real p1(unit = "mmHg") = 741.7 "Suction pressure";
parameter Real p2(unit = "mmHg") = 769.6 "Discharge pressure";
parameter Real v2(unit = "m/s") = 45.7 "Velocity at discharge";
parameter Real MW(unit = "kg/kmol") = 28.97 "Molecolar weight of air";
parameter Real V(unit = "m^3/kg") = 22.414 "Volume per kmol";
parameter Real To(unit = "K") = 273.2 "Standard temperature";
parameter Real T1(unit = "K") = 294.1 "Temperature at inlet";
parameter Real T2(unit = "K") = 366.3 "Exit temperature";
parameter Real F(unit = "J/kg") = 0 "Frictional losses";
parameter Real eff(unit = "-") = 60 "Effeciency of fan";

//==============
//Variable section
Real rho1(unit = "kg/m^3") "Density of the fluid at suction point";
Real rho2(unit = "kg/m^3") "Density of the fluid at discarge point";
Real rho_avg(unit = "kg/m^3") "Average density of the fluid";
Real M(unit = "kg/s") "Mass flow rate of the fluid";
Real pressure_head(unit = "J/kg") "Pressure head";
Real Ws(unit = "J/kg") "Break power";
Real break_hp(unit = "kW") "Break horse power";

//===============
//Equation section
equation
rho1 = (MW/V)*(To/T2)*(p1/760) ; // Density at suction
 // 760 is divided to mmHg to atm
rho2 = rho1*(p2/p1) ; // Density at discharge
rho_avg = (rho1 + rho2)/2 ; // Average density
M = (Q/(60*V))*(To/T1)*(MW) ; // Mass flow rate of the fluid
pressure_head = ((p2 - p1)/760)*(101325/rho_avg) ; // Pressure head
   // 101325 to convert mmHg to N/m^2 
-Ws = pressure_head + (v2^2/2) + F ; // Shaft work
break_hp = (-Ws*M)/((eff/100)*1000) ; // Break horse power
     // 1000 is divided to convert W to kW
end Ex3_3_2;
//==============================================
