// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.4-3 Page 149
//Title: Scale up of turbine agitation system
//================================================
model Ex3_4_3

//===============
// Libraries 
extends Modelica.Constants;

//=============
//Parameter section
parameter Real D1(unit = "m") = 1.83 "Diameter before scale up";
parameter Real Da(unit = "m") = 0.61 "Diameter of agitator";
parameter Real H1(unit = "m") = 1.83 "Height of the agitator";
parameter Real rho(unit = "kg/m^3") = 929 "Density of the fluid";
parameter Real mu(unit = "kg/m.s") = 0.01 "Viscosity 1";
parameter Real sur(unit = "-") = 3 "Scale up ratio";
parameter Real N1(unit ="rev/s") = 1.5 "Revolution per second before rotation";
parameter Real Np(unit = "-") = 5 "Power number for the reynolds number from graph";

//============
//Variable section
Real R(unit = "-") "Ratio of volumes";
Real NRe(unit = "-") "Reynolds number of the fluid";
Real N2_1(unit = "rev/s") "Number of revolutions per second in case 1";
Real N2_2(unit = "rev/s") "Number of revolutions per second in case 2";
Real D2(unit = "m") "Diameter 2";
Real V1(unit = "m^3") "Volume before scale up";
Real V2(unit = "m^3") "Volume after scale up";
Real P1(unit = "kW/m^3") "Power required for agitation per unit volume in case 1 before scaling up";
Real P2(unit = "kW/m^3") "Power required for agitation per unit volume in case 1 during scaling";
Real P2_2(unit = "kW/m^3")"Power required for agitation per unit volume in case 2";

//=============
//Equation section
equation
V1 = (pi/4)*(D1^2)*H1 ; // Volume before scale up
V2 = V1*sur ; // Volume after scale up
D2 = R*Da; 
R = (V2/V1)^(1/3) ; 
N2_1 = N1*(1/R)^(2/3) ; 
   // 2/3 is chosen for equal mass transfer constraint
NRe = (D1^2*(N2_1)*rho)/mu ; // Reynolds number of the fluid
P2 = (Np*rho*(N2_1)^3*D2^5)/(V2*1000) ; //Power consumed perunit volume
    // P2 is divided by 1000 to convert W to kW
P1 = ((Np*rho*(N2_1)^3*D2^5)/sur)/(V1*1000); // Power consumed per unit volume
    // P1 is divided by 1000 to convert W to kW
N2_2 = N1*(1/R)^(1) ; 
    // For equal motion of liquid
P2_2 = (Np*rho*(N2_2)^3*D2^5)/(V2*1000) ; // Power consumed in second case per unit volume
    // P2_2 is divided by 1000 to convert W to kW
end Ex3_4_3;
//==============================================
