// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.10-2 Page 280
//Title: Combined convection and radiation from the tube 
//================================================
model Ex4_10_2

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real D(unit = "m") = 0.0254 "Outer diameter of the tube";
parameter Real L(unit = "m") = 0.61 "Length of the tube";
parameter Real epslon(unit = "-") = 0.6 "Emissivity of the metal tube";
parameter Real T1(unit = "K") = 588 "cold end temperature";
parameter Real T2(unit = "K") = 1088 "Hot end temperature";
parameter Real sigma(unit = "K^4/m^2.W") = 5.676 "Stephen boltzmen constant";

//================
//Variable section
Real hr(unit = "W/m^2.K") "Heat transfer coefficient due to radiation";
Real hc(unit = "W/m^2.K") "Heat transfer coefficient due to convection";
Real q(unit = "W") "Amount of heat transferred";
Real A(unit = "m^2") "Area required for heat transfer";

//================
//Equation section
equation
hc = 1.32*((T2-T1)/D)^0.25 ; // Heat transfer due to convection
hr = epslon*sigma*((T2/100)^4 - (T1/100)^4)/(T2-T1) ; // Heat transfer coefficient due to radiation
A = pi*D*L ; // Area required for heat transfer
q = (hc+hr)*A*(T1-T2) ; // Heat transferred
end Ex4_10_2;
//===============================================
