// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.3-1 Page 223
//Title: Heat flow through insulated wall of cold room
//================================================
model Ex4_3_1

//==================
//Parameter section
parameter Real DelxA(unit = "m") = 0.0127 "Thickness of the portion A";
parameter Real DelxB(unit = "m") = 0.1016 "Thickness of the portion B";
parameter Real DelxC(unit = "m") = 0.0762 "Thickness of the portion C";
parameter Real kA(unit = "W/m.K") = 0.151 "Thermal conductivity of A";
parameter Real kB(unit = "W/m.K") = 0.0433 "Thermal conductivity of B";
parameter Real kC(unit = "W/m.K") = 0.762 "Thermal conductivity of C";
parameter Real T1(unit = "K") = 255.4 "Inside temperature of the wall";
parameter Real T4(unit = "K") = 297.1 "Outside temperature of the wall";

//==================
//Variable section
Real q(unit = "W") "Amount of heat transferred";
Real T2(unit = "K") "Interface temperature";

//===================
//Equation section
equation
q = (T1 - T4)/((DelxA/kA)+(DelxB/kB)+(DelxC/kC)) ; // Heat transferred
q = (T1 - T2)/(DelxA/kA) ; // Temperature of the interface
end Ex4_3_1;
//================================================
