// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.3-2 Page 225
//Title: Heat loss from insulated pipe
//================================================
model Ex4_3_2

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real r1(unit = "m") = 0.0127 "Inner radius of the cylinder";
parameter Real r2(unit = "m") = 0.0254 "Middle radius of the cylinder";
parameter Real r3(unit = "m") = 0.0508 "Outer radius of the cylinder";
parameter Real l(unit = "m") = 0.305 "Length of the cylinder";
parameter Real kA(unit = "W/m.K") = 21.63 "Thermal conductivity of A";
parameter Real kB(unit = "W/m.K") = 0.2423 "Thermal conductivity of B";
parameter Real T1(unit = "K") = 811 "Inside temperature of the wall";
parameter Real T3(unit = "K") = 310.8 "Outside temperature of the wall";

//===============
//Variable section
Real A1(unit = "m^2") "Inner area of cylinder";
Real A2(unit = "m^2") "Middle area of cylinder";
Real A3(unit = "m^2") "Outer area of cylinder";
Real Alm1(unit = "m^2") "Logrithmic mean area 1";
Real Alm2(unit = "m^2") "Logrithmic mean area 2";
Real q(unit = "W") "Amount of heat transferred";
Real T2(unit = "K") "Interface temperature";

//================
//Equation section
equation
A1 = 2*pi*r1*l ; // Inner area
A2 = 2*pi*r2*l ; // Middle area
A3 = 2*pi*r3*l ; // Outer area
Alm1 = (A2-A1)/(log(A2/A1)) ; // Logrithmic mean area
Alm2 = (A3-A2)/(log(A3/A2)) ; // Logrithmic mean area
q = (T1-T3)/(((r2-r1)/(kA*Alm1))+((r3-r2)/(kB*Alm2))) ; // Total heat transferred
q = (T1-T2)/(((r2-r1)/(kA*Alm1))) ; // Temperature of interface
end Ex4_3_2;
//================================================
