// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.5-4 Page 245
//Title: Heat transfer area and Log mean temperature difference
//================================================
model Ex4_5_4

//===============
//Parameter section
parameter Real Th1(unit = "K") = 371.9 "Inlet temperature of hot fluid";
parameter Real Th2(unit = "K") = 349.7 "Exit temperature of hot fluid";
parameter Real Tc1(unit = "K") = 288.6 "Inlet temperature of cold fluid";
parameter Real Cph(unit = "kJ/kg.K") = 2.30 "Specific heat capacity of hot fluid";
parameter Real Cpc(unit = "kJ/kg.K") = 4.187 "Specific heat capacity of cold fluid";
parameter Real mh(unit = "kg/h") = 3630 "Mass flow rate of hot fluid";
parameter Real mc(unit = "kg/h") = 1450 "Mass fow rate of cold fluid";
parameter Real U(unit = "W/m^2.K") = 340 "Overall heat transfer coefficient";

//===============
//Variable section
Real Tc2(unit = "K") "Exit temperature of cold fluid";
Real LMTD1(unit = "K") "Logarithmic mean temperature difference";
Real A1(unit = "m^2") "Area required for heat transfer";
Real LMTD2(unit = "K") "Logarithmic mean temperature for parellel flow";
Real A2(unit = "m^2") "Area required for heat transfer";

//================
//Equation section
equation
mh*Cph*(Th1-Th2) = mc*Cpc*(Tc2-Tc1) ; // Energy balance
LMTD1 = ((Th1-Tc2) - (Th2-Tc1))/(log((Th1-Tc2)/(Th2-Tc1))) ; // LMTD 1
A1 = (mh*Cph*(Th1-Th2)*(1000/3600))/(U*LMTD1) ; // Area required for heat trnsfer
 // It is multiplied by 1000 to convert kJ to J and divided by 3600 to convert h to s
LMTD2 = ((Th1-Tc1) - (Th2-Tc2))/(log((Th1-Tc1)/(Th2-Tc2))) ; // LMTD 1
A2 = (mh*Cph*(Th1-Th2)*(1000/3600))/(U*LMTD2) ; // Area required for heat trnsfer
end Ex4_5_4;
//===========================================================
