// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.6-1 Page 248
//Title: Cooling of a copper fin
//================================================
model Ex4_6_1

//=================
//Parameter section
parameter Real Tb(unit = "C") = 15.6 "Inside temperature of the wall";
parameter Real Tw(unit = "C") = 82.2 "Tube wall temperature";
parameter Real L(unit = "m") = 0.051 "Length of the fin";
parameter Real rho(unit = "kg/m^3") = 1.097 "Density of the air";
parameter Real mu(unit = "Pa.s") = 1.95E-05 "Viscosity of the air";
parameter Real v(unit = "m/s") = 12.2 "Velocity of the air flowing";
parameter Real Npr(unit = "-") = 0.704 "Prandle number of the fluid";
parameter Real k(unit = "W/m.K") = 0.028 "Thermal conductivity of air";

//================
//Variable section
Real Tf(unit = "C") "Film temperature";
Real NRe(unit = "-") "Reynolds number";
Real h1(unit = "W/m^2.K") "Heat transfer coefficient";
Real h2(unit = "W/m^2.K") "Heat transfer coefficient";

//=================
//Equation section
equation
Tf = (Tb+Tw)/2 ; // Film temperature
NRe = L*rho*v/mu ; // Reynolds number of air
h1*L/k = 0.664*NRe^0.5*Npr^(1/3) ; // Heat transfer coefficient 1
h2*L/k = 0.0366*NRe^0.8*Npr^(1/3) ; // Heat transfer coefficient 2
end Ex4_6_1;
//====================================================
