// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.6-2 Page 249
//Title: Cooling of a sphere
//================================================
model Ex4_6_2

//================
//Parameter section
parameter Real D(unit = "m") = 0.051 "Diameter of the sphere";
parameter Real rho(unit = "kg/m^3") = 1.097 "Density of the air";
parameter Real mu(unit = "Pa.s") = 1.95E-05 "Viscosity of the air";
parameter Real v(unit = "m/s") = 12.2 "Velocity of the air flowing";
parameter Real Npr(unit = "-") = 0.704 "Prandle number of the fluid";
parameter Real k(unit = "W/m.K") = 0.028 "Thermal conductivity of air";

//================
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";

//=================
//Equation section 
equation
NRe = D*rho*v/mu ; // Reynolds number of air
h*D/k = 2+0.6*NRe^0.5*Npr^(1/3) ; // Heat transfer coefficient
end Ex4_6_2;
//================================================
