// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.6-3 Page 250
//Title: Heating air by bank of tubes
//================================================
model Ex4_6_3

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real D(unit = "m") = 0.0254 "Diameter of the pipe";
parameter Real L(unit = "m") = 0.305 "Length of the pipe";
parameter Real Ti(unit = "C") = 15.6 "Inlet temperature of air";
parameter Real To(unit = "C") = 21.1 "Outlet temperature of air";
parameter Real Tw(unit = "C") = 57.2 "Surface temperature";
parameter Real rho(unit = "kg/m^3") = 1.137 "Density of the air";
parameter Real v(unit = "m/s") = 7.62 "Velocity of the air flowing";
parameter Real mu(unit = "Pa.s") = 1.90E-05 "Viscosity of the air";
parameter Real k(unit = "W/m.K") = 0.027 "Thermal conductivity of the pipe";
parameter Real Npr(unit = "-") = 0.705 "Prandle number of the fluid";
parameter Real Cp(unit = "kJ/kg.K") = 1.0048 "Specific heat cpacity";
parameter Real C(unit = "m") = 0.278 "Parameters in correlation";
parameter Real m(unit = "m") = 0.62 "Parameters in correlation";
parameter Real Sn(unit = "m") = 0.0381 "Distance between two adjacent tubes";

//===============
//Variable section
Real Tb(unit = "C") "Average bulk temperature";
Real Tf(unit = "C") "Film temperature";
Real vmax(unit = "m/s") "Velocity of air";
Real NRe(unit = "-") "Reynolds number";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real A(unit = "m^2") "Area of tubes required";
Real q(unit = "W") "Actual heat transferred";
Real At(unit = "m^2") "Tube area";
Real mf(unit = "kg/s") "Mass flow rate of the fluid";
Real DelT(unit = "C") "Temperature gradient";

//===============
//Equation section
equation
Tb = (Ti+To)/2 ; // Bulk temperature
Tf = (Tb+Tw)/2 ; // Film temperature
vmax = v*Sn/(Sn-D) ; // Maximum velocity of air
NRe = D*vmax*rho/mu ; // Reynolds number
h = (k/D)*C*NRe^m*Npr^(1/3) ; // Heat transfer coefficient
A = 40*pi*D*L ; // Surface area of tubes, 40 tubes are present
q = 0.9*h*A*(Tw-Tb) ; // Total heat transferred
At = 10*Sn*L ; // Tube area of each row
mf = v*rho*At ; // Mass flow rate of entering air
 // 3600 is multiplied to convert h to s
q = mf*Cp*1000*DelT ; // Temperature gradient
end Ex4_6_3;
//===================================================
