// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.7-1 Page 254
//Title: Natural convection from vertical air and oven
//================================================
model Ex4_7_1

//================
//Parameter section
parameter Real L(unit = "m") = 0.305 "Length of the pipe";
parameter Real Tb(unit = "C") = 311 "Outlet temperature of air";
parameter Real Tw(unit = "K") = 505.4 "Surface temperature";
parameter Real rho(unit = "kg/m^3") = 0.867 "Density of the air";
parameter Real mu(unit = "Pa.s") = 2.32E-05 "Viscosity of the air";
parameter Real k(unit = "W/m.K") = 0.0343 "Thermal conductivity of the pipe";
parameter Real Npr(unit = "-") = 0.69 "Prandle number of the fluid";
parameter Real a(unit = "m") = 0.59 "Parameters in correlation";
parameter Real m(unit = "m") = 0.25 "Parameters in correlation";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//================
//Variable section
Real Tf(unit = "C") "Film temperature";
Real NGr(unit = "-") "Grashoff number";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real q(unit = "W") "Actual heat transferred";
Real beta(unit = "K^-1") "Volumetric coefficient of expansion";

//================
//Equation section
equation
Tf = (Tb+Tw)/2 ; // Film temperature
beta = 1/Tf ; // Volumetric coefficient of expansion
NGr = L^3*rho^2*g*beta*(Tw-Tb)/(mu^2) ; // Grashoff number
h = (k/L)*a*(NGr*Npr)^m ; // Heat transfer coefficient
q = h*L^2*(Tw-Tb) ; // Total heat transfer
end Ex4_7_1;
//===================================================
