// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.9-2 Page 271
//Title: Effectiveness of a heat exchanger 
//================================================
model Ex4_9_2

//================
//Parameter section
parameter Real Th1(unit = "C") = 383 "Inlet temperature of hot fluid";
parameter Real Tc1(unit = "C") = 308 "Inlet temperature of cold fluid";
parameter Real Tc2(unit = "C") = 370 "Exit temperature of cold fluid assumed";
parameter Real Cph(unit = "kJ/kg.K") = 1.89 "Specific heat capacity of hot fluid";
parameter Real Cpc(unit = "kJ/kg.K") = 4.187 "Specific heat capacity of cold fluid";
parameter Real mc(unit = "kg/s") = 0.667 "Mass fow rate of cold fluid";
parameter Real mh(unit = "kg/s") = 2.85 "Mass fow rate of cold fluid";
parameter Real A1(unit = "m^2") = 15 "Area required for heat transfer";
parameter Real U(unit = "W/m^2.K") = 300 "Overall heat transfer coefficient";

//================
//Variable section
Real q(unit = "W") "Heat transferred";
Real Tc(unit = "K") "Exit temperature of the cold fluid";
Real cH(unit = "W/K") "Capacity of hot fluid";
Real cC(unit = "W/K") "Capacity of cold fluid";
Real NTU(unit = "-") "Number of transfer units";
Real cmax(unit = "W/K") "Maximum heat capacity";
Real cmin(unit = "W/K") "Minimum heat capacity";
Real epslon(unit = "-") "Ratio of cmin to cmax";

//=================
//Equation section
equation
cH = mh*Cph*1000 ; // Capacity of hot fluid
cC = mc*Cpc*1000 ; // Capacity of cold fluid
if cH > cC then // Decision making statements
cH = cmax ;
cC = cmin ;
else
cC = cmax ;
cH = cmin ;
end if;
epslon = cmin/cmax ; // Ratio of cmin to cmax
NTU =U*A1/cmin ; // Number of transfer units
 // From figure effectiveness is 0.71
q = 0.71*cmin*(Th1-Tc1) ; // Heat transferred
q = cC*(Tc-Tc1) ; // Exit temperature of cold fluid
end Ex4_9_2;
//===============================================================
