// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-3-1 Page:337
//Title: Freezing temperature in the ground
//================================================
model Ex5_3_1

//===============
//Parameter section
parameter Real To(unit = "C") = 15.6 "Initial temperature of surface";
parameter Real T1(unit = "C") = -17.8 "Temperature after cooling";
parameter Real h(unit = "W/m^2.K") = 11.36 "Heat transfer coefficient";
parameter Real x_center(unit = "m") = 0 "Distance from the surface";
parameter Real k(unit = "W/m.K") = 0.865 "Thermal conductivity of solid";
parameter Real t(unit = "h") = 5 "Time taken or allowed for cooling";
parameter Real a(unit = "m^2/s") = 4.65E-07 "Thermal diffusivity of the solid";
//From graph it has been found that the value of 1-Y = 0.63, figure 5.3-3, page:337
parameter Real Y(unit = "-") = 0.37 "Value obtained from graph";
parameter Real T2(unit = "K") = 273.2 "Temperature for the case 2";

//==============
//Variable section
Real A(unit = "-") "The value of x at T=5" ;
Real B(unit = "-") "A term in unsteady heat transfer";
Real T(unit = "K") "Initial temperature of the surface";
Real x1(unit = "m") "Distance from the surface in case 2";
Real A1(unit = "-") "Unsteady value in case 2";
Real Temp(unit = "-") "ratio of temperatures in case 2";

//================
//Equation section
equation
A = x_center/(2*sqrt(a*t*3600)) ; // Unsteady term 1
 // 3600 is multiplied to convert s to h
B = h*sqrt(a*t*3600)/k ; // Unsteady term 2
 // 3600 is multiplied to convert s to h
1-Y = ((T-(To+273.15))/(T1-To)) ; // Temperature obtained after 5 hrs
 // To is added with 273 to convert C to K
A1 = x1/(2*sqrt(a*t*3600)) ; // Unsteady term 1
 // 3600 is multiplied to convert s to h
Temp = ((T2-To)/(T1-To)) ;
// For this value corresponding "x/2*sqrt(a*t)" is found
(x1/(2*sqrt(a*t*3600))) = 0.16 ; // The distance from surface
  // 3600 is multiplied to convert s to h
end Ex5_3_1;
//==========================================================
