// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-3-2 Page:338
//Title: Heat conduction in a slab of butter
//================================================
model Ex5_3_2

//===============
//Parameter section
parameter Real x(unit = "mm") = 0 "Distance from the surface at center";
parameter Real x1(unit = "mm") = 20.8 "Distance from center to top surface";
parameter Real x2(unit = "mm") = 46.2 "Distance from the surface";
parameter Real h(unit = "W/m^2.K") = 0.197 "Heat transfer coefficient";
parameter Real t(unit = "h") = 5 "Time taken or allowed for cooling";
parameter Real To(unit = "K") = 277.6 "Initial temperature of surface";
parameter Real T1(unit = "K") = 297.1 "Temperature after cooling";
parameter Real k(unit = "W/m.K") = 0.197 "Thermal conductivity of the solid";
parameter Real Cp(unit = "kJ/kg.K") = 2.3 "Specific heat capacity of solid";
parameter Real rho(unit = "kg/m^3") = 998 "Density of butter";

//=============
//Variable section
Real a(unit = "m^2/s") "Thermal diffusivity of the rectangular box";
Real m(unit = "-") "Parameters needed to use in figure";
Real X(unit = "-") "Parameters needed to use in figure";
Real n(unit = "-") "Parameters needed to use in figure";
Real T_1(unit = "K") "Temperture of top surface";
Real n1(unit = "-") "Parameters needed to use in figure";
Real T_2(unit = "K") "Temperture at the center";
Real n2(unit = "-") "Parameters needed to use in figure";
Real T_3(unit = "K") "Temperture of bottom surface";

//================
//Equation section
equation
a = k/(rho*Cp*1000) ; // Thermal diffusivity
m = k/(h*(x2/1000)) ; // Parameter needed in graph
X = (a*t*3600/(x2/1000)^2) ; // Parameter needed in graph
n = x2/x2 ; // From top surface the ratio of length
 // From graph Y is 0.25 figure:5.3-5, page : 340
0.25 = ((T1-T_1)/(T1-To)) ; // Temperature of top surface
n1 = x1/x2 ; // From the center, the ratio of length
 // From graph Y1 is 0.45 figure:5.3-5, page : 340
0.45 = ((T1-T_2)/(T1-To)) ; // Temperature of center
n2 = x/x2 ; // From the bottom, the ratio of length
 // From graph Y2 is 0.5 figure:5.3-5, page : 340
0.5 = ((T1-T_3)/(T1-To)) ; // Temperature of center
end Ex5_3_2;
//=======================================================
