// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-4-2 Page:356
//Title: Unsteady state conduction using the digital computer
//================================================
model Ex5_4_2

//==============
//Parameter section
parameter Real M(unit = "-") = 2 "Explicit value of schmidt method";
parameter Real Deltax(unit = "m") = 0.05 "Difference between two nodes";
parameter Real alpha(unit = "m^2/s") = 2E-05 "Thermal diffusivity of the solid";

//==============
//Variable section
Real Deltat(unit = "s") "Increment in the time step";

//===============
//Equation section
equation
M = Deltax^2/(alpha*Deltat) ; // Difference in time step
end Ex5_4_2;
//================================================
